﻿SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Azimi
-- Create date: 
-- Description:	
-- =============================================
/****** Object:  StoredProcedure [dbo].[AccWarehouseExpandDeliveryProc]    Script Date: 2023/02/20 11:19:18 ب.ظ ******/
--DROP PROCEDURE [dbo].[AccWarehouseExpandDeliveryProc]
--GO

CREATE PROCEDURE AccWarehouseExpandDeliveryProc
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	SET NOCOUNT ON;

	DECLARE @SerialRightNumverLen as int
	select @SerialRightNumverLen=NumberValue from AppSetting where Name like 'Warehouse.SerialRightNumverLen' 
	/*
	insert into AppSetting(Name,Description,TheValue,UserID,DateValue,NumberValue)
	Values ('Warehouse.SerialRightNumverLen','','',0,'2000-1-1',10)
	*/
	truncate table AccWarehouseExpandDelivery

	DECLARE @ID as bigint
	DECLARE @SerialFrom as NVARCHAR(20)
	DECLARE @SerialTo as NVARCHAR(20)
	DECLARE @NSerialFrom as bigint
	DECLARE @NSerialTo as bigint
	DECLARE @Serial as bigint

	DECLARE myCursor CURSOR FOR 
	select ID, VSerialFrom, VSerialTo from AccWarehouseDelivery 
	
	OPEN myCursor
	FETCH NEXT FROM myCursor INTO @ID, @SerialFrom, @SerialTo
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @SerialFrom=RTRIM(@SerialFrom)
		SET @SerialTo=RTRIM(@SerialTo)
		set @NSerialFrom = Power(cast(10 as bigint), @SerialRightNumverLen) + CAST ( Right(@SerialFrom, @SerialRightNumverLen) as bigint)
		set @NSerialTo = Power(cast(10 as bigint), @SerialRightNumverLen) + CAST ( Right(@SerialTo, @SerialRightNumverLen) as bigint)

		SET @Serial=@NSerialFrom
		while @Serial <= @NSerialTo
		BEGIN
			Insert Into AccWarehouseExpandDelivery(ParentID,Serial) Values(@ID, @Serial)
			SET @Serial=@Serial+1
		END

		FETCH NEXT FROM myCursor INTO @ID, @SerialFrom, @SerialTo
	END
	CLOSE myCursor
	DEALLOCATE myCursor

	--select * from AccWarehouseExpandDelivery
	-- select sum(VRequest) from AccWarehouseDelivery
	/*
	select count(*) from AccWarehouseExpandDelivery
	select sum(VRequest) from AccWarehouseDelivery

	delete AccWarehouseDelivery where Len(VSerialFrom)<>Len(VSerialTo) or Len(VSerialFrom) < 1
	Select * From AccWarehouseDelivery where Len(VSerialFrom)<>Len(VSerialTo) or Len(VSerialFrom) < 1

	select ID, [WareDetailsID], VRequest, VSerialFrom, VSerialTo, (-CAST( Right(RTRIM(VSerialFrom), 7) as bigint)+CAST ( Right(RTRIM(VSerialTo), 7) as bigint))+1
	from AccWarehouseDelivery
	where VRequest <> (-CAST( Right(RTRIM(VSerialFrom), 7) as bigint)+CAST ( Right(RTRIM(VSerialTo), 7) as bigint))+1
	*/


	--use [master] END
END
GO
